#!/usr/bin/env python3

import os
import re

KWINRC = os.path.expanduser("~/.config/kwinrulesrc")
RULE_UID = "f7bf79f2-49f0-4bf6-8501-4a645b58fbbd"
RULE_CONTENT = f"""[{RULE_UID}]
Description=Settings for Bear Clock
skiptaskbar=true
skiptaskbarrule=2
wmclass=Godot_Engine Clock
wmclasscomplete=true
wmclassmatch=1
"""

print("=== Fenster-Regel für Bären-Uhr hinzufügen (dann erscheint es nicht in der Taskleiste) ===")
if input("Fortfahren? (j/N): ").lower() not in ['j', 'y']:
    print("Abgebrochen")
    exit(0)

# Backup
if os.path.exists(KWINRC):
    import shutil
    import time
    backup = f"{KWINRC}.backup.{int(time.time())}"
    shutil.copy2(KWINRC, backup)
    print(f"✓ Backup: {backup}")

# Regel prüfen
with open(KWINRC, 'r') as f:
    content = f.read()
    if f"[{RULE_UID}]" in content:
        print("⚠️  Regel existiert bereits!")
        input("Enter zum Beenden")
        exit(1)

# Regel hinzufügen
with open(KWINRC, 'a') as f:
    f.write("\n" + RULE_CONTENT + "\n")

# General-Abschnitt aktualisieren
with open(KWINRC, 'r') as f:
    lines = f.readlines()

# UIDs sammeln
uids = []
for line in lines:
    match = re.match(r'^\[([a-f0-9-]+)\]$', line.strip())
    if match and match.group(1) != "General":
        uids.append(match.group(1))

# General finden und aktualisieren
for i, line in enumerate(lines):
    if line.strip() == "[General]":
        # count aktualisieren
        for j in range(i+1, len(lines)):
            if lines[j].startswith("count="):
                lines[j] = f"count={len(uids)}\n"
                break
        
        # rules aktualisieren/einfügen
        rules_found = False
        for j in range(i+1, len(lines)):
            if lines[j].startswith("rules="):
                lines[j] = f"rules={','.join(uids)}\n"
                rules_found = True
                break
        
        if not rules_found:
            lines.insert(i+2, f"rules={','.join(uids)}\n")
        break

# Datei speichern
with open(KWINRC, 'w') as f:
    f.writelines(lines)

print("\n✓ Regel hinzugefügt!")
print("\nZusammenfassung:")
print(f"  • UID: {RULE_UID}")
print(f"  • Name: Bear Clock")
print(f"  • WM_CLASS: clock_qt")
print(f"  • Taskleiste: ausgeblendet")
print("\nHinweis: Funktioniert nach der nächsten Anmeldung.")
input("\nEnter zum Beenden")
